<?php

class makecommerceparcellabelsModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        if(Tools::getIsset('order_ids')){
            $order_ids = Tools::getValue('order_ids');
            $parcel_labels = $this->getParcelLabel($order_ids);
            die(json_encode($parcel_labels));
        }
    }

    public function getParcelLabel($order_ids)
    {
        $credentials = [];
        foreach($order_ids as $order_id)
        {
            $order = new Order($order_id);
            foreach ($order->getShipping() as $carrier)
            {
                $carrier_obj = new Carrier($carrier['id_carrier']);
                if (!$carrier_obj->external_module_name) {
                    continue;
                }

                $carrierModule = Module::getInstanceByName($carrier_obj->external_module_name);
                if ($carrierModule instanceof MakeCommerceCarrierModule) {
                    if (empty($carrierModule->getShipmentId($order))) {
                        $carrierModule->createShipments($order);
                    }

                    $carrierName = $carrierModule->getCarrierPrefix();
                    $omnivaTmsEnabled = MakeCommerce::getConfig('OMNIVA_USE_MK_TMS');
                    $dpdTmsEnabled = MakeCommerce::getConfig('DPD_USE_MK_TMS');

                    $isTmsEnabled =
                        ($carrierName === 'OMNIVA' && $omnivaTmsEnabled) ||
                        ($carrierName === 'DPD' && $dpdTmsEnabled);

                    $isDifferentCarrier = $carrierModule->getCarrierId(true, 'courier') !== $order->id_carrier;

                    $addToCredentials = true;
                    if ($isTmsEnabled && $isDifferentCarrier) {
                        $addToCredentials = false;
                    } else {
                        foreach ($credentials as $key => $credential) {
                            if ($credential['carrier'] == $carrierName) {
                                $addToCredentials = false;
                            }
                        }
                    }

                    if ($addToCredentials) {
                        $credentials[] = $carrierModule->getCredentials();
                    }

                    $ordersData[] = $carrierModule->formatParcelLabelRequest($order);
                    break;
                }
            }
        }

        if (isset($ordersData))
        {
            $makecommerce = new MakeCommerce();

            $request_body = array(
                'credentials' => $credentials,
                'orders' => $ordersData,
                'printFormat' => $makecommerce->getConfig('label_pgsize')
            );
            $api = $makecommerce->getApi();
            $label = $api->createLabels($request_body);

            if (isset($label->errors)) {
                $errors = [];
                foreach ($label->errors as $error) {
                    if (isset($error->errorMessage)) {
                        $errors[] = $error->orderId . ' - ' . $error->errorMessage;
                    }
                }
                return ['error' => json_encode($errors)];
            }
            return array($label->labelUrl);
        }

        return null;
    }

    public function display()
    {
        return false;
    }
}
