<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_3_3_3($module)
{
    $password = $module->getConfig('smartpost_password');
    Configuration::deleteByName('smartpost_password');
    Configuration::deleteByName('smartpost_username');

    // LP express fields to add to config
    $fields = array(
        'lpexpress',
        'lp_express_lt_username',
        'lp_express_lt_password',
        'lp_express_lt_template',
        'lp_express_lt_countrysel',
        'lp_express_lt_sender_name',
        'lp_express_lt_phone',
        'lp_express_lt_email',
        'lp_express_lt_city',
        'lp_express_lt_street',
        'lp_express_lt_building',
        'lp_express_lt_zip',
    );

    foreach ($fields as $field) {
        $module->updateConfig($field, null);
    }

    $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'makecommerce_lpexpress` (
			  `shipmentid` varchar(64) PRIMARY KEY,
			  `lpExpressCartIdentifier` varchar(64),
			  `parcelSize` varchar(64)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;';

    if (!Db::getInstance()->execute($sql)) {
        return false;
    }

    if (!empty($password)) {
        return $module->updateConfig('smartpost_apikey', $password);
    }

    return true;
}