jQuery(document).ready(function() {
    var orderSelected = 'body#checkout';

    var makecommerce_carrier = {
        checked_options: $('input[name^=delivery_option]', '#js-delivery'),
        ids: [],
        address: 0
    };

    var selected_carrier = $('input[name^=delivery_option]:checked', '#js-delivery').val();
    if (typeof selected_carrier !== 'undefined') {
        selected_carrier = selected_carrier.substring( 0, selected_carrier.length - 1 );
    }
    var makecommerce_carrier_error = '';
    var selected_makecommerce_carriers;
    var selects = false;
    var module;
    var carriers;
    var disableCheckout = false;

    makecommerce_carrier.checked_options.each( function(row ) {
        newCurrent = (makecommerce_carrier.checked_options[row].value.substring(0,(makecommerce_carrier.checked_options[row].value.length -1)));
        if($("#" + 'mk_selector_' + newCurrent).length != 0) {
            if (newCurrent == selected_carrier) {
                $("#" + 'mk_selector_' + newCurrent).show();
                if ($( "div#mk_selector_" + newCurrent + " select.mycommerce_carrier:selected") > 0) {
                    disableCheckout = false;
                } else {
                    disableCheckout = true;
                }
            } else {
                $("#" + 'mk_selector_' + newCurrent).hide();
            }
        }
    });

    for (var i = makecommerce_carrier.checked_options.length - 1; i >= 0; i--) {
        makecommerce_carrier.ids[getAddress(makecommerce_carrier.checked_options[i].id)] = makecommerce_carrier.checked_options[i].id;
    }

    jQuery('form#js_delivery').off('click').on('click', 'label', function(evt){
        makecommerce_carrier.address = getAddress(evt.currentTarget.control.id);
        if(!(makecommerce_carrier.address in makecommerce_carrier.ids))
            makecommerce_carrier.ids[makecommerce_carrier.address] = evt.currentTarget.control.id;
        if(jQuery.inArray(evt.currentTarget.control.id, makecommerce_carrier.ids) !== -1)
            return false;
        makecommerce_carrier.ids[makecommerce_carrier.address] = evt.currentTarget.control.id;
    });

    moveList();
    // hideCarriers();

    if($('.delivery-option input:checked').parents('.delivery-option').find('.makecommerce_carrier').val() == "0"){
        disableCheckout = true;
    }else{
        disableCheckout = false;
    }

    $('body#checkout section.checkout-step .custom-radio input[type=radio]').on('click', function() {
        if($(this).parents('.delivery-option').find('.makecommerce_carrier').length && $(this).parents('.delivery-option').find('.makecommerce_carrier').val() == 0){
            disableCheckout = true;
        }else{
            disableCheckout = false;
        }
    });

    $('input[name^=delivery_option]', '#js-delivery').on('change',function(row){
        newSelected = $(this).val().substring(0,$(this).val().length - 1);
        makecommerce_carrier.checked_options.each( function(row ) {
            newCurrent = (makecommerce_carrier.checked_options[row].value.substring(0,(makecommerce_carrier.checked_options[row].value.length -1)));
            if($("#" + 'mk_selector_' + newCurrent).length != 0) {
                if (newCurrent == newSelected) {
                    if ($( "div#mk_selector_" + newCurrent + " > select[name=terminals]").val() > 0) {
                        disableCheckout = false;
                    } else {
                        disableCheckout = true;
                    }
                    selected_carrier = newSelected;
                    $("#" + 'mk_selector_' + newCurrent).show();
                } else {
                    $("#" + 'mk_selector_' + newCurrent).hide();
                }
            } else {
                if (newCurrent == newSelected) {
                    selected_carrier = newSelected;
                }
            }
        });
    });

    $('.makecommerce_carrier').on('change',function(){
        if($(this).val() == 0) {
            disableCheckout = true;
        } else {
            disableCheckout = false;
        }
    });

    $(".delivery-options-list button[type='submit']").on( "click", function( event ) {

        let selectedElement = $('#delivery_option_' + selected_carrier);
        let parent = selectedElement.parents('.delivery-option');
        let targetElement = parent.find('[name="terminals"]');

        if($('div#mk_selector_' + selected_carrier).length != 0) {
            var code = $( "div#mk_selector_" + selected_carrier + " > select[name=terminals]").val();
            if (code && code != "0") {
                disableCheckout = false;
            } else {
                disableCheckout = true;
            }
        } else if (targetElement.val() == 0) {
            disableCheckout = true;
        } else {
            disableCheckout = false;
        }
        if(disableCheckout){
            event.preventDefault();
            $('html, body').stop().animate({
                scrollTop: $("#checkout-delivery-step").offset().top
            }, 1000);
            alert(chooseTerminal);
        }
    });
});

function getAddress(id_string) {
    var splitted = id_string.split('_');
    return splitted[2];
}

function updateCarrierTerminal(id_address, name, module) {
    var data = {
        terminal_id: $('select#' + module + '_' + id_address).val(),
        id_address: id_address,
        name: module
    };
    var current_carrier;
    $.ajax({
        type: 'POST',
        url:  $('.'+name+'_'+id_address+'_ajax').first().val(),
        data: jQuery.param(data),
        dataType: 'json',
        success: function(json) {
            current_carrier = $('select#' + module + '_' + id_address).parent().parent().find('.custom-radio input');
            if(
                (current_carrier.length === 1 && !current_carrier.prop('checked')) ||
                    parseInt(data.terminal_id, 10) === 0
                )
            { // is_carrier_checked || selected_terminal || deselected_terminal
                if (current_carrier.length === 1)
                {
                    current_carrier.prop('checked', true).click().change();
                }
                else
                {
                    updateCarrierSelectionAndGift();
                }
            }
        }
    });
}

function updateCarrierCity(id_address, name, currentapm, citytext) {
    var data = {
        terminal_city: $('select#' + name + '_location').val(),
        id_address: id_address,
        currentapm: currentapm,
        cityText: citytext
    };
    var apms = this[name + '_terminals'];
    var content = '';
    var selectedExists = 0;
    apms.forEach( function (element) {
       if (element.city == data.terminal_city) {
           content += '<option value="' + element.id + '"';
           if (element.id == currentapm) {
               content += ' selected="selected"';
               selectedExists = 1;
           }
           content += ' data-address="' + element.name + '">' + element.name + '</option>' +"\n";
       }
    });
    if ( selectedExists == 0)
        content = '<option value="0" selected="selected">' + citytext + '</option>'+"\n" + content;
    if ( selectedExists == 1)
        content = '<option value="0">' + citytext + '</option>'+"\n" + content;
    $('select#' + name + '_' + id_address).html(content);
}


function moveList()
{

    $('.delivery-options input').each(function() {
        module = $('#hook-display-before-carrier > #makecommerce_carrier_'+parseInt($(this).val()));
        if (module.length === 1)
        {
            $(this).closest('.delivery-option').find('label').append(module.html());
            module.remove();
        }
    });

}

function hideCarriers()
{
    // hide if no terminals are displayed to user
    $('[name="hide_carrier"]').each(function () {
        if (this.value) {
            $(this).closest('.row .delivery-option').hide()
        }
    })
}
