<div id="makecommerce_label">
    <div class="card mt-2">
        <div class="card-header"><img width="16" height="16" src="{$base_url|escape:'htmlall':'UTF-8'}modules/makecommerce/logo.png" alt="" /> {l s='Shipment actions' mod='makecommerce'}</div>
        <div class="card-body">
           {if isset($error) && $error}
                <div class="alert alert-warning">
                    <button type="button" class="close" data-dismiss="alert">×</button>
                    <ul class="list-unstyled">
                        <li>{$error}</li>
                    </ul>
                </div>
            {/if}
            <form method="post" action="{$smarty.server.REQUEST_URI|escape:'htmlall':'UTF-8'}">
                <button type="submit" class="btn btn-default" name="submitMKLabel">
                    <i class="icon-print"></i>
                    {l s='Print parcel label' mod='makecommerce'}
                </button>
                {if empty($shipment_id)}
                    <button type="submit" class="btn btn-default" name="submitMKRegister">
                        <i class="icon-arrow-up"></i>
                        {l s='Register order' mod='makecommerce'}
                    </button>
                {/if}
                {if !empty($shipment_id) && $trackingUrl}
                    <a type="submit" href="{$trackingUrl}" class="btn btn-default" target="_blank">
                        <i class="icon-arrow-up"></i>
                        {l s='Track order' mod='makecommerce'}
                    </a>
                {/if}

                {if $is_courier}

                    <a class="btn btn-default" id="makecommerce-adress-edit"
                       href="{$address_url}"> {l s='Change destination address' mod='makecommerce'}
                    </a>

                    {else}

                    <a class="btn btn-default" href="#" data-toggle="modal" data-target="#updateOrderShippingDestination" aria-expanded="false">
                        {l s='Change destination terminal' mod='makecommerce'}
                    </a>
                    <div class="modal fade" id="updateOrderShippingDestination" tabindex="-1" role="dialog" aria-modal="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Edit shipping details</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="form-group">
                                        <label class="form-control-label" for="update_order_shipping_new_carrier_id">
                                            {l s='Parcel terminals' mod='makecommerce'}
                                        </label>
                                        {if $parcel_grouping}
                                            {include "../hook/terminals.tpl"}
                                        {else}
                                            {include "../hook/terminals2.tpl"}
                                        {/if}
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">
                                        Cancel
                                    </button>
                                    <button name="submitMKParcelDestinationUpdate" type="submit" class="btn btn-primary">
                                        Update
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                {/if}


            </form>
        </div>
    </div>
</div>

{if !empty($possibleSizes)}
    <div id="makecommerce_label">
        <div class="card mt-2">
            <div class="card-header"><img width="16" height="16" src="{$base_url|escape:'htmlall':'UTF-8'}modules/makecommerce/logo.png" alt="" /> {l s='Parcel actions' mod='makecommerce'}</div>
            <div class="card-body">
                <form method="post" action="{$smarty.server.REQUEST_URI|escape:'htmlall':'UTF-8'}">
                    <label for="parcelSize" class="form-control-label label-on-top col-12">{l s='LP express parcel sizes' mod='makecommerce'}</label>
                    <select class="custom-select" name="parcelSize" id="parcelSize">
                        {foreach $possibleSizes as $item}
                            <option {if $parcelSize == $item->value} selected="selected" {/if} value="{$item->value}">{$item->label}</option>
                        {/foreach}
                    </select>

                    <button type="submit" class="btn btn-default" name="submitMKParcelChange">
                        <i class="icon-arrow-up"></i>
                        {l s='Save size change' mod='makecommerce'}
                    </button>
                </form>
            </div>
        </div>
    </div>
{/if}

{if isset($label_url) && $label_url}
    <script>
        function isValidUrl(value) {
            try {
                new URL(value);
                return true;
            } catch (e) {
                return false;
            }
        }

        if (isValidUrl('{$label_url}')) {
            window.open('{$label_url}', '_blank');
        }
    </script>
{/if}