<?php

class makecommerceparcellabelsModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        if(Tools::getIsset('order_ids')){
            $order_ids = Tools::getValue('order_ids');
            $parcel_labels = $this->getParcelLabel($order_ids);
            die(json_encode($parcel_labels));
        }
    }

    public function getParcelLabel($order_ids)
    {
        foreach($order_ids as $order_id){
            $order = new Order($order_id);
            foreach ($order->getShipping() as $carrier){
                $carrier_obj = new Carrier($carrier['id_carrier']);
                if (!$carrier_obj->external_module_name) {
                    continue;
                }

                $carrierModule = Module::getInstanceByName($carrier_obj->external_module_name);
                if ($carrierModule instanceof MakeCommerceCarrierModule) {
                    if (empty($carrierModule->getShipmentId($order))) {
                        $carrierModule->createShipments($order);
                    }
                    $ordersData[] = $carrierModule->formatParcelLabelRequest($order);
                    $credentials[] = $carrierModule->getCredentials();
                    break;
                }
            }
        }

        if(isset($credentials) and isset($ordersData)){
            $makecommerce = new MakeCommerce();

            $request_body = array(
                'credentials' => $credentials,
                'orders' => $ordersData,
                'printFormat' => $makecommerce->getConfig('label_pgsize')
            );
            $api = $makecommerce->getApi();
            $label = $api->createLabels($request_body);

            return array($label->labelUrl);
        }

        return null;
    }

    public function display()
    {
        return false;
    }
}
