<?php

class makecommercevalModuleFrontController extends ModuleFrontController
{
    const STATE_COMPLETE = 'COMPLETED';
    const STATE_APPROVED = 'APPROVED';
    const STATE_CANCELLED = 'CANCELLED';
    const STATE_EXPIRED = 'EXPIRED';

    const MSG_TOKEN_RTN = 'token_return';

    public $ssl = true;

    private $json_data;

    public function initContent()
    {
        parent::initContent();
        $this->json_data = json_decode(Tools::getValue('json'));
        if (isset($this->json_data->message_type) && $this->json_data->message_type == self::MSG_TOKEN_RTN) {
            $api = $this->module->getApi();
            if (is_null($api)) {
                $this->context->smarty->assign([
                    'banklink_msg' => $this->module->l('Invalid maksekeskus configuration', 'val'),
                    'msg_class' => 'info'
                ]);
            } else {
                $transaction = $api->getTransaction($this->json_data->transaction->id);
                if (!is_null($transaction)) {
                    $order = new Order((int)$transaction->reference);
                    $customer = new Customer((int)$order->id_customer);
                    // change payment method name when changed via iframe
                    if (isset($transaction->card->card) &&
                        !str_contains(mb_strtolower($order->payment), mb_strtolower($transaction->card->card->type))
                    ) {
                        $order->payment = $this->module->displayName . ' ' . ucfirst(mb_strtolower($transaction->card->card->type));
                        $order->save();
                    }

                    if (Validate::isLoadedObject($order)) {
                        // removed link to previous order
                        if (isset($this->context->cookie->currentOrder)) {
                            unset($this->context->cookie->currentOrder);
                        }
                        if ($order->hasBeenPaid()) {
                            $this->saveTransactionId($this->json_data->transaction->id, $order->reference);
                            $this->clearTransactionCookies();
                            Tools::redirect($this->getOrderConfirmationUrl($order->id_cart, $this->module->id, $order->id, $customer->secure_key));
                        }
                        if (isset($this->json_data->token->id)) {
                            $payment = $api->createPayment($transaction->id, array(
                                'token' => $this->json_data->token->id,
                                'amount' => $transaction->amount,
                                'currency' => $transaction->currency
                            ));
                            if (!is_null($payment) && (
                                    $payment->transaction->status == self::STATE_COMPLETE ||
                                    $payment->transaction->status == self::STATE_APPROVED
                                )) {
                                if (isset($this->context->cookie->id_cart)) {
                                    unset($this->context->cookie->id_cart);
                                }
                                $order->valid = true;
                                $order->setCurrentState(Configuration::get('PS_OS_PAYMENT'));
                                $this->saveTransactionId($this->json_data->transaction->id, $order->reference);
                                $this->clearTransactionCookies();
                                Tools::redirect($this->getOrderConfirmationUrl($order->id_cart, $this->module->id, $order->id, $customer->secure_key));
                            }
                        } else {
                            $cart = Cart::getCartByOrderId($order->id);
                            $this->context->cookie->oldCartId = $cart->id;
                            MakeCommerce::restoreCart();
                            $this->context->smarty->assign([
                                'try_again' => true,
                                'order_page_link' => Context::getContext()->link->getPageLink('order', true, null, 'submitReorder=true'),
                                'banklink_msg' => $this->module->l('Payment unsuccessful', 'val'),
                                'msg_class' => 'info'
                            ]);
                        }
                    }
                }
            }
        } elseif ($this->verifyMac()) {
            $order = new Order((int)$this->json_data->reference);
            $customer = new Customer((int)$order->id_customer);
            if (Validate::isLoadedObject($order)) {
                // removed link to previous order
                if (isset($this->context->cookie->currentOrder)) {
                    unset($this->context->cookie->currentOrder);
                }
                if ($order->hasBeenPaid()) {
                    $this->saveTransactionId($this->json_data->transaction, $order->reference);
                    $this->clearTransactionCookies();
                    Tools::redirect($this->getOrderConfirmationUrl($order->id_cart, $this->module->id, $order->id, $customer->secure_key));
                } elseif ($this->json_data->status == self::STATE_COMPLETE) {
                    $order->valid = true;
                    $order->setCurrentState(Configuration::get('PS_OS_PAYMENT'));
                    $this->saveTransactionId($this->json_data->transaction, $order->reference);
                    $this->clearTransactionCookies();
                    Tools::redirect($this->getOrderConfirmationUrl($order->id_cart, $this->module->id, $order->id, $customer->secure_key));
                } elseif (
                    $this->json_data->status == self::STATE_CANCELLED ||
                    $this->json_data->status == self::STATE_EXPIRED
                ) {
                    $order->setCurrentState(Configuration::get('PS_OS_CANCELED'));
                    $this->context->cookie->currentOrder = $this->json_data->reference;
                    $cart = Cart::getCartByOrderId($this->context->cookie->currentOrder);
                    $this->context->cookie->oldCartId = $cart->id;
                    $this->context->cookie->id_customer = $order->id_customer;
                    $iso_code = \Context::getContext()->language->iso_code;
                    MakeCommerce::restoreCart();
                    $this->context->smarty->assign([
                        'banklink_msg' => $this->module->l('Order canceled', 'val'),
                        'msg_class' => 'info',
                        'try_again' => true,
                        'order_page_link' => Context::getContext()->link->getPageLink('order', true, null, 'submitReorder=true'),
                        'language' => [
                            'locale' => $iso_code,
                            'iso_code' => $iso_code
                        ]
                    ]);
                } else {
                    Tools::redirect($this->context->link->getPageLink('order', true));
                }
            }
        } else {
            $this->context->smarty->assign(array(
                'msg_class' => 'info',
                'banklink_msg' => $this->module->l('Invalid signature', 'val')
            ));
        }
        $this->setTemplate('module:makecommerce/views/templates/front/final.tpl');
    }

    private function clearTransactionCookies()
    {
        if ($this->context->cookie->__get('mk_transaction_id')) {
            $this->context->cookie->__unset('mk_transaction_id');
        }
        if ($this->context->cookie->__get('mk_transaction_reference')) {
            $this->context->cookie->__unset('mk_transaction_reference');
        }
    }

    private function getOrderConfirmationUrl($cartId, $moduleId, $orderId, $key)
    {
        return 'index.php?controller=order-confirmation&id_cart=' . $cartId .
            '&id_module=' . $moduleId . '&id_order=' . $orderId . '&key=' . $key;
    }

    private function verifyMac()
    {
        $api = $this->module->getApi();

        return $api->verifyMac(Tools::getAllValues());
    }

    private function saveTransactionId($transaction_id, $order_reference){
        $sql = 'UPDATE `'._DB_PREFIX_.'order_payment`
			SET `transaction_id` = \''.$transaction_id.'\'
			WHERE `order_reference` = \''.$order_reference.'\'';

        Db::getInstance()->Execute($sql);
    }

}
