<?php

class makecommercepaymentspayLaterModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        $valid_cart = $this->module->validateCart($this->context->cart->id);
        if(!$valid_cart) {
            Tools::redirect($this->context->link->getPageLink('order', true));
        }

        $method = $this->module->getPaymentMethod(Tools::getValue('method'));
		if (empty($method) || !($method->type == MakeCommercePayments::TYPE_PAYLATER)) {
            Tools::redirect($this->context->link->getPageLink('order', true));
        }

        $country = Tools::getValue('country');
        $transaction = $this->module->createTransaction($method, $country);
        if ($method->type == 'payLater') {
            $url = $this->module->getBankUrlFromTransaction($transaction, $method->code);
        }

        if (isset($url)) {
            Tools::redirectLink($url);
        }

        $this->context->smarty->assign(array(
            'banklink_msg' => $this->module->l('Something went wrong !', 'banklinks'),
            'msg_class' => 'danger'
        ));
        $this->setTemplate('final.tpl');
    }
}
